/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: User_xxx.c $:

  Description:
    USER implemented functions called by the netXTransport Toolkit.

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2019-10-31  Added USER_GetVersionString() for custom version information handling
    2013-02-13  initial version

**************************************************************************************/

/****************************************************************************/
/*! \file User_xxx.c
    Function which must be implemented by the user                          */
/****************************************************************************/

#include "netXTransport.h"
#include "HilTransportLayer.h"
#include "ConnectorAPI.h"
#include "OS_Dependent.h"

/*****************************************************************************/
/*! Print a trace message from netXtransport toolkit
*     \param ptDevInstance  Device instance the trace is coming from
*     \param ulTraceLevel   see TRACE_LVL_XXX defines
*     \param szFormat       printf style format string
*     \param ...            printf arguments                                 */
/*****************************************************************************/
void USER_Trace(NETX_TRANSPORT_DATA_T* ptnetXTransportInst, uint32_t ulTraceLevel, char* szFormat, ...)
{
  UNREFERENCED_PARAMETER( ptnetXTransportInst);
  UNREFERENCED_PARAMETER( ulTraceLevel);
  UNREFERENCED_PARAMETER( szFormat);

}

/*****************************************************************************/
/*! Initialize trace
*     \param ptnetXTransportInst Pointer to netXTransport instance           */
/*****************************************************************************/
void USER_TraceInitialize(NETX_TRANSPORT_DATA_T* ptnetXTransportInst)
{
  UNREFERENCED_PARAMETER( ptnetXTransportInst);
}

/*****************************************************************************/
/*! De-initialize trace
*     \param ptnetXTransportInst Pointer to netXTransport instance           */
/*****************************************************************************/
void USER_TraceDeInitialize(NETX_TRANSPORT_DATA_T* ptnetXTransportInst)
{
  UNREFERENCED_PARAMETER( ptnetXTransportInst);
}

/*****************************************************************************/
/*! Function retrieves connector specific timeout
*     \param ptConnector  Pointer to connector
*     \param ptConnector  Pointer to returned timeout
/*****************************************************************************/
void USER_GetConnectorTimeout( PNETX_CONNECTOR_T ptConnector, uint32_t* pulTimeout)
{
  UNREFERENCED_PARAMETER( ptConnector);
  UNREFERENCED_PARAMETER( pulTimeout);
}

/*****************************************************************************/
/*! Get custom version string for xDriverGetInformation()
*     \param ulMaxLen   Length in Bytes available in szVersion
*     \param szVersion  Buffer for returning string                          */
/*****************************************************************************/
void USER_GetVersionString (uint32_t ulMaxLen, char* szVersion)
{
  #define STR_EXPAND(tok) #tok
  #define STR(tok) STR_EXPAND(tok)

  const char abVer[] = "NXT-Toolkit V"STR(NXT_VERSION_MAJOR)"."STR(NXT_VERSION_MINOR)"."STR(NXT_VERSION_BUILD)"."STR(NXT_VERSION_REV);

  OS_Strncpy(szVersion, abVer, ulMaxLen);
}

/*****************************************************************************/
/*! User defined function to start the toolkit's cyclic thread
*     returns pointer t thread info required to stop (USER_StopCyclicThread) */
/*****************************************************************************/
void* USER_StartCyclicThread(void)
{
  return NULL;
}

/*****************************************************************************/
/*! User defined function to stop the toolkit's cyclic thread
*     \param pvCyclicThreadInfo User defined parameter                       */
/*****************************************************************************/
void USER_StopCyclicThread( void* pvCyclicThreadInfo)
{
  UNREFERENCED_PARAMETER( pvCyclicThreadInfo);
}
